-------------------------------------------
--   --
-------------------------------------------
--AG: 30.01.2006
--       1
-- 
--    
--AG: 12.01.2006
-- 
--     ID 
--   -  
-------------------------------------------
--

function processPhobia(name)
	return((string.upper(getPersonParameterStr(name, "PHOBIA")) == "PSYCHO") and
		service.showAck(name, name.."_special_01", getAIConst().psychoProcessed))
end

function onSignal(name, signal, context, context2)
calls.enter("onSignal",name..","..signal)

	if(not isUnitValid(name)) then
calls.leave("onSignal",name..","..signal)		
		return
	end
	
	--  
	if (signal == "") then
		log(name, "!   ")
calls.leave("onSignal",name..","..signal)		
		return
	else
		log(name, "C:", signal, context, context2)
	end
	
	if(signal == "ITEM_FIXED") then
		local possible = getPersonParameter(name, "MECHANICAL")/4
		if (possible > 0) then
			processStatChange(name, calcDiceRoll(possible), "MECHANICAL", false)
		end
		processStatChange(name, calcDiceRoll(10), "DEXTERITY", false)
calls.leave("onSignal",name..","..signal)
		return
	end	

	local put_to_container = false

	if (((CUR_MISSION.Name ~= nil) and (Humans[name] == nil)) or ((CUR_MISSION.Name == nil) and (Mercs[name] == nil))) then
                if(not isValid(context)) then
calls.leave("onSignal",name..","..signal)
                        return
                end
		local temp = name
		name = context
		context = temp
		put_to_container = true
	else
		log(name, "     :", name, signal)
	end
	
	if(not service.isPlayer(name)) then
		log(name, "   !",context)
		if(isValid(CUR_MISSION.Name)) then
			if(signal == "BLEEDING") then
				if(not healthOK(name)) then
					hideRemark(name)
					setPersonParameter(name, "BREATH", -1000)
					setPersonParameter(name, "AP", 0)
				end
			elseif(signal == "ENEMY_WOUNDED") then
				if(isUnitValid(context)) then
					local moraleMod = getAIConst().mbEnemyHit
					if(relations(team(name),team(context))~=ALLY) then
						service.remarksMgr(name, signal, context)
					else
						moraleMod = getAIConst().mpAllyHit
					end
					updateMorale(name, moraleMod, signal)
				end	
			elseif(signal == "KILLED_ENEMY") then
				Sectors[CUR_MISSION.Name].onKill()
				if(isUnitValid(context)) then
					local moraleModPersonal = getAIConst().mbEnemyKilled
					local moraleModCommon = getAIConst().mbEnemyKilledAll
					if(relations(team(name),team(context))~=ALLY) then
						service.remarksMgr(name, signal, context)
					else
						moraleModPersonal = getAIConst().mpAllyKilled
						moraleModCommon = getAIConst().mpAllyKilledAll
					end
					updateMorale(name, moraleModPersonal, signal)
					updateMorale(service.getHumanList(name, ALLY, false), moraleModCommon, signal)
					if(team(context)~=PLAYER) then
						updateMorale(service.getHumanList(context, ALLY, false), getAIConst().mpKilledAll, "ALLY_KILLED")
						hideRemark(context)
					end
					service.removeFromVisibleG(name, context)
				end
			elseif(signal == "GET_WOUNDED") then
				updateMorale(name, getAIConst().mpHit, "GET_WOUNDED")
			end
		end
calls.leave("onSignal",name..","..signal)
		return
	end

	if(not healthOK(name)) then
calls.leave("onSignal",name..","..signal)		
		return
	end

	local health = getPersonParameter(name, "HEALTH")
	local mechanical = getPersonParameter(name, "MECHANICAL")
	local health_max = getPersonParameter(name, "DURABILITYMAX")
	local level = getPersonParameter(name, "LEVEL")
	local strength = getPersonParameter(name, "STRENGTH")
	local dexterity = getPersonParameter(name, "DEXTERITY")
	local agility = getPersonParameter(name, "AGILITY")
	local wisdom = getPersonParameter(name, "WISDOM")
	local leadership = getPersonParameter(name, "LEADERSHIP")
	local explosives = getPersonParameter(name, "EXPLOSIVES")
	local breath = getPersonParameter(name, "BREATH")
	local marksmanship = getPersonParameter(name, "MARKSMANSHIP")
	local medical = getPersonParameter(name, "MEDICAL")

--	
	if(signal == "ENEMY_WOUNDED") then
		local damage = 10 														-- get from target
		local roll = 5
		local moraleMod = MoraleBonus.MIN
		roll = roll * damage

		local melee = getMelee(name, false)
		local hands = getHandIndex(name)

		if(not hasGun(name,"a","primary")) then
			processStatChange(name, calcDiceRoll(25), "DEXTERITY", false)
			if(hands~=melee) then
				processStatChange(name, calcDiceRoll(25), "STRENGTH", false)
			end
		else
			processStatChange(name, calcDiceRoll(roll), "MARKSMANSHIP", false)
		end
		if (isUnitValid(context)) then
			local cteam_id = team(context)
			if(cteam_id == PLAYER) then
				moraleMod = MoralePenalty.TINY
			else
				complexReputationChange(CUR_MISSION.Forces[cteam_id], "WOUNDED")
			end
		end
		updateMorale(name, moraleMod, signal)
 	elseif(signal == "SHOOTING") then
 		if(processPhobia(name)) then
 			setFiringType(name, "burst")
		end
--		processStatChange(name, calcDiceRoll(3), "MARKSMANSHIP", false)
	elseif(signal == "THROW_GRENADE") then
		processPhobia(name)
		processStatChange(name, calcDiceRoll(35), "STRENGTH", false)
		processStatChange(name, calcDiceRoll(35), "DEXTERITY", false)
	elseif(signal == "KILLED_ENEMY") then
		Sectors[CUR_MISSION.Name].onKill()
		local rnd = math.random()
		local count = math.random(4)
		local moraleMod1 = MoraleBonus.SMALL
		local moraleMod2 = MoraleBonus.TINY
		service.showAck(name, name.."_enemy_killed_0"..count, 0.75)
		local level = 1
		local roll = 10
		if(isUnitValid(context)) then
			level = getPersonParameter(context, "LEVEL")
			roll = roll * level / 3
			hideRemark(context)
			local cteam_id = team(context)
			if (cteam_id == PLAYER) then
				moraleMod1 = MoralePenalty.ADEQUATE
				moraleMod2 = MoralePenalty.SMALL
			else
				local bra = 0
				local cforce_id = CUR_MISSION.Forces[cteam_id]
				
				complexReputationChange(cforce_id, "KILLED")
			
				if ((checkRelations(PLAYER, cforce_id) == ENEMY) or ((cforce_id == ARMY) and (CURRENT_ALLY ~= ARMY))) then
					KILL_COUNT = KILL_COUNT + 1
					bra = -0.05
				elseif (checkRelations(PLAYER, cforce_id) == ALLY) then
					bra = 0.25
				end
				
				if (bra ~= 0) then
					changeBadReputation(bra)
				end
				updateMorale(service.getHumanList(context, ALLY, false), getAIConst().mpKilledAll, "ALLY_KILLED")
				service.removeFromVisibleG(name, context)
			end
		end
		processStatChange(name, calcDiceRoll(roll), "LEVEL", false)
		updateMorale(name, moraleMod1, signal)
		updateMorale(CUR_MISSION.Mercs, moraleMod2, signal)
	elseif(signal == "GET_WOUNDED") then
		processStatChange(name, calcDiceRoll(5), "LEVEL", false)
		updateMorale(name, MoralePenalty.TINY, signal)
		if (isUnitValid(context)) then
			if((Humans[context].attack_type=="HAND_ATTACK") or 
				(Humans[context].attack_type=="KNIFE_ATTACK")) then
				local rnd_str = tostring(math.random(2))
				service.showAck(name, name.."_melee_hit_0"..rnd_str, 0.5)
			end
		end
		local count = tostring(math.random(4))
		if (health < 31) then
			service.showAck(name, name.."_heavy_wounded_0"..count, 1)
		end
	elseif(signal == "HEALED_SOMEONE") then
		local possible = getPersonParameter(name, "MEDICAL")/4
		if (possible > 0) then
			processStatChange(name, calcDiceRoll(possible), "MEDICAL", false)
		end
		processStatChange(name, calcDiceRoll(getPersonParameter(name, "DEXTERITY")/8), "DEXTERITY", false)
		updateMorale(name, MoraleBonus.MIN, signal)
		if(isValid(context) and 
			healthOK(context) and
			isValid(CUR_MISSION.Name)) then
			local bWas = getPersonParameter(context, "BREATH")
			local sBPCost = 4*(1000-bWas/10)
			fighter_tb.deductPoints(context,sBPCost,bWas)
		end
	elseif(signal == "UNJAMMED_GUN") then
		processStatChange(name, calcDiceRoll(10), "DEXTERITY", false)
		if (mechanical > 0) then
			processStatChange(name, calcDiceRoll(10), "MECHANICAL", false)
		end
		updateMorale(name, MoraleBonus.MIN, signal)
	elseif (signal == "KNIFE_ATTACK") then
		processPhobia(name)
		local exp = 30
		processStatChange(name, calcDiceRoll(exp), "DEXTERITY", false)
	elseif(signal == "HAND_ATTACK") then
	        processPhobia(name)
		local exp = 30
		processStatChange(name, calcDiceRoll(exp), "DEXTERITY", false)
		processStatChange(name, calcDiceRoll(exp), "STRENGTH", false)
	elseif(signal == "RELOAD") then
--		processStatChange(name, calcDiceRoll(5), "DEXTERITY", false)
	elseif(signal == "NOAMMO") then
		local message = "_out_of_ammo_0"
		if (context == signal) then
			message = "_refuse_0"
		else
			processStatChange(name, calcDiceRoll(3), "WISDOM", false)	
		end
		local count = tostring(math.random(4))
		service.showAck(name, name..message..count, 1)
	elseif(signal == "JAMMED_GUN") then
		processStatChange(name, calcDiceRoll(1), "LEVEL", false)
		local count = tostring(math.random(4))
		service.showAck(name, name.."_gun_jammed_0"..count, 1)
	elseif(signal == "BLEEDING") then
		service.showAck(name, name.."_bleeding_0"..tostring(math.random(2)), 0.66)
		if(not healthOK(name)) then
			setPersonParameter(name, "BREATH", 0)
			setPersonParameter(name, "AP", 0)
		end
	elseif (signal == "USE") then
	elseif (signal == "TAKE") then
		if (put_to_container == true) then
			log(name, " ", context2, " ", context)
		else
			log(name, " ", context2, " ", context)
		end

--- signals below really not realized

	elseif(signal == "DOOR_DAMAGED") then
		processStatChange(name, calcDiceRoll(10), "MARKSMANSHIP", false)
	elseif(signal == "THROW_KNIFE") then
		local exp = 50
		local roll = 2
		roll = exp / roll
		processStatChange(name, calcDiceRoll(roll), "MARKSMANSHIP", false)
		processStatChange(name, calcDiceRoll(roll), "DEXTERITY", false)
		processStatChange(name, calcDiceRoll(5), "STRENGTH", false)
	elseif(signal == "SET_BOMB") then
		processStatChange(name, calcDiceRoll(25), "EXPLOSIVES", false)
	elseif(signal == "FOUND_ITEM") then
		processStatChange(name, calcDiceRoll(5), "WISDOM", false)
	elseif(signal == "BOMB_FAILED") then
		processStatChange(name, calcDiceRoll(10), "EXPLOSIVES", false)
	elseif(signal == "TRAP_SPOTTED") then
		local trap_dif = 10 													-- get from trap
		local roll = 3
		roll = roll * trap_dif
		processStatChange(name, calcDiceRoll(roll), "WISDOM", false)
		processStatChange(name, calcDiceRoll(roll), "EXPLOSIVES", false)
	elseif(signal == "DISARMED_TRAP") then
		local trap_dif = 50 													-- get from trap
		local roll = 6
		roll = roll * trap_dif
		processStatChange(name, calcDiceRoll(roll), "EXPLOSIVES", false)
	elseif(signal == "TRAP_BOOM") then
		local trap_dif = 10 													-- get from trap
		local roll = 3
		roll = roll * trap_dif
		processStatChange(name, calcDiceRoll(roll), "EXPLOSIVES", false)
	elseif(signal == "BOMB_SPOTTED") then
		processStatChange(name, calcDiceRoll(10), "EXPLOSIVES", false)
	elseif(signal == "ITEMS_COMBINED") then
		local attach = 10 														-- calc
		local roll = 20
		roll = roll - attach
		processStatChange(name, calcDiceRoll(roll), "MECHANICAL", false)
		updateMorale(name, MoraleBonus.MIN, signal)
	elseif(signal == "DETONATOR_SET") then
		processStatChange(name, calcDiceRoll(25), "EXPLOSIVES", false)
	elseif(signal == "DOOR_FORCED") then
		processStatChange(name, calcDiceRoll(20), "STRENGTH", false)
		updateMorale(name, MoraleBonus.MIN, signal)
	elseif(signal == "DOOR_DAMAGED_BY_FORCE") then
		processStatChange(name, calcDiceRoll(5), "STRENGTH", false)
	elseif(signal == "CANNOT_FORCE_DOOR") then
		processStatChange(name, calcDiceRoll(1), "STRENGTH", false)
		updateMorale(name, MoralePenalty.MIN, signal)
	elseif(signal == "LOCK_PICKED") then
		local lock_dif = 50 													-- get from door
		local roll1 = 5
		local roll2 = 10
		roll1 = lock_dif / roll1
		roll2 = lock_dif / roll2
		processStatChange(name, calcDiceRoll(roll1), "MECHANICAL", false)
		processStatChange(name, calcDiceRoll(roll2), "DEXTERITY", false)
		updateMorale(name, MoraleBonus.MIN, signal)
	elseif (signal == "UNAWARE_ENEMY") then
		processStatChange(name, calcDiceRoll(10), "LEVEL", false)
	elseif(signal == "ATTACKED_BY_NEW_ENEMY") then
		processStatChange(name, calcDiceRoll(5), "LEVEL", false)
		updateMorale(name, MoralePenalty.MIN, signal)
	elseif(signal == "ASSISTED") then
		local level = 1 														-- get level of target
		local roll = 5
		roll = roll * level
		processStatChange(name, calcDiceRoll(roll), "LEVEL", false)
		updateMorale(name, MoraleBonus.MIN, signal)
	elseif(signal == "SNEAKED") then
		processStatChange(name, calcDiceRoll(5), "AGILITY", false)
	elseif(signal == "BOMB_DO_DAMAGE") then
		local damage = 5 														-- get from targets
		local roll = 10
		roll = roll * damage
		processStatChange(name, calcDiceRoll(roll), "EXPLOSIVES", false)
	elseif(signal == "DODGED_MELEE") then
		processStatChange(name, calcDiceRoll(10), "AGILITY", false)
		updateMorale(name, MoraleBonus.MIN, signal)
	elseif(signal == "DODGE_HAND") then
		processStatChange(name, calcDiceRoll(8), "AGILITY", false)
		updateMorale(name, MoraleBonus.MIN, signal)
	end
calls.leave("onSignal",name..","..signal)
end